/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;

public class OAuthBearerScopeUtils {
    private static final Pattern INDIVIDUAL_SCOPE_ITEM_PATTERN = Pattern.compile("[\\x23-\\x5B\\x5D-\\x7E\\x21]+");

    public static boolean isValidScopeItem(String scopeItem) {
        return INDIVIDUAL_SCOPE_ITEM_PATTERN.matcher(Objects.requireNonNull(scopeItem)).matches();
    }

    public static List<String> parseScope(String spaceDelimitedScope) throws OAuthBearerConfigException {
        ArrayList<String> retval = new ArrayList<String>();
        for (String individualScopeItem : Objects.requireNonNull(spaceDelimitedScope).split(" ")) {
            if (individualScopeItem.isEmpty()) continue;
            if (!OAuthBearerScopeUtils.isValidScopeItem(individualScopeItem)) {
                throw new OAuthBearerConfigException(String.format("Invalid scope value: %s", individualScopeItem));
            }
            retval.add(individualScopeItem);
        }
        return Collections.unmodifiableList(retval);
    }

    private OAuthBearerScopeUtils() {
    }
}

